package doABC;

import java.nio.ByteBuffer;
import java.util.*;
import FlashReader.*;

public class OptionDetail extends SwfTools {
	
	private HashMap<Integer, String> flagsKind = new HashMap<Integer, String>();
	
	private int start;
	private int end;
	
	//struktury
	private int val;
	private int  kind; //u8
	
	public OptionDetail(ByteBuffer bbuf){
		super();
		initFlags();
		option_detail(bbuf);
	}
	
	public void initFlags(){
		flagsKind.put( 0x03, "CONSTANT_Int");
		flagsKind.put( 0x04, "CONSTANT_UInt");
		flagsKind.put( 0x06, "CONSTANT_Double");
		flagsKind.put( 0x01, "CONSTANT_Utf8");
		flagsKind.put( 0x0B, "CONSTANT_True");
		flagsKind.put( 0x0A, "CONSTANT_False");
		flagsKind.put( 0x0C, "CONSTANT_Null");
		flagsKind.put( 0x00, "CONSTANT_Undefined");
		flagsKind.put( 0x08, "CONSTANT_Namespace");
		flagsKind.put( 0x16, "CONSTANT_PackageNamespace");
		flagsKind.put( 0x17, "CONSTANT_PackageInternalNs");
		flagsKind.put( 0x18, "CONSTANT_ProtectedNamespace");
		flagsKind.put( 0x19, "CONSTANT_ExplicitNamespace");
		flagsKind.put( 0x1A, "CONSTANT_StaticProtectedNs");
		flagsKind.put( 0x05, "CONSTANT_PrivateNs");
	}
	
	private void option_detail(ByteBuffer bbuf){
		start = bbuf.position();
		
		val= unsigned30int(bbuf);
		
		kind = unsignedByte(bbuf.get());

		end = bbuf.position()-1;
		
	}
	
	public ArrayList<Byte> toByteCode(){
		ArrayList<Byte> result = new ArrayList<Byte>();
			
			for (byte b: getUI32(val))
				result.add(b);
		
			result.add((byte)kind);
	
		return result;
	}
	
	
	//tostrings
	public String String(){
		StringBuffer wynik = new StringBuffer();
		
		wynik.append( ">" + start+"\n" );
		
		wynik.append( "val: " + val+"\n" );
			
		wynik.append( "kind: " +  getKind_string() +"\n" );
			
		wynik.append( "<" + end+"\n" );		
		
		return wynik.toString();
		
	}
	
	public String toString(){
		String wynik ="";
		wynik+="option_detail";
		return wynik;
	}

	public String getKind_string() {
		
		return flagsKind.get(kind);
	}

}
